## RabbitMQ 3.7.4

RabbitMQ `3.7.4` is a patch release that primarily includes bug fixes.

### Upgrades and Compatibility

This release has no known incompatibilities with earlier 3.7.x versions.
See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades.

See [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Bug Fixes

 * Priority queues could terminate when the node was under memory pressure and needed to
   offload messages to disk.

   GitHub issue: [rabbitmq-server#1535](https://github.com/rabbitmq/rabbitmq-server/issues/1535)

 * queue leader locator strategy of `min-masters` was affected by queue binding count and could
   select the wrong node.

   GitHub issue: [rabbitmq-server#1519](https://github.com/rabbitmq/rabbitmq-server/issues/1519)

 * It was not possible to set [randomized startup delay](https://www.rabbitmq.com/cluster-formation.html#initial-formation-race-condition) range via new style config file.

   GitHub issue: [rabbitmq-server#1531](https://github.com/rabbitmq/rabbitmq-server/issues/1531)

 * Windows scripts used `USE_LONGNAME` from the env file incorrectly.

   GitHub issue: [rabbitmq-server#1508](https://github.com/rabbitmq/rabbitmq-server/issues/1508)

 * systemd notification implementation was prone to shell escaping issues.

   GitHub issue: [rabbitmq-server#1187](https://github.com/rabbitmq/rabbitmq-server/issues/1187)

 * It wasn't possible to configure `delegate_count` via new style config file.

   GitHub issue: [rabbitmq-server#1497](https://github.com/rabbitmq/rabbitmq-server/issues/1497)

 * It wasn't possible to configure `net_ticktime` via new style config file.

   GitHub issue: [rabbitmq-server#1522](https://github.com/rabbitmq/rabbitmq-server/issues/1522)

#### Enhancement

 * It is now possible to configure max number of Erlang processes and atoms using
   `RABBITMQ_MAX_NUMBER_OF_PROCESSES` (`MAX_NUMBER_OF_PROCESSES` in `rabbitmq-env.conf`) and `RABBITMQ_MAX_NUMBER_OF_ATOMS`
   (`MAX_NUMBER_OF_ATOMS`) environment variables, respectively.

   GitHub issue: [rabbitmq-server#1528](https://github.com/rabbitmq/rabbitmq-server/pull/1528)

 * `SCHEDULER_BIND_TYPE` and `DISTRIBUTION_BUFFER_SIZE` now can be used in `rabbitmq-env.conf` without
   the `RABBITMQ_` prefix.

   GitHub issue: [rabbitmq-server#1528](https://github.com/rabbitmq/rabbitmq-server/pull/1528)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-plugins set` failed when was used in offline mode (with `--offline`)

   GitHub issue: [rabbitmq-cli#241](https://github.com/rabbitmq/rabbitmq-cli/issues/241)

 * `rabbitmqctl list_*` command streaming now can be restricted to a set of client TCP ports
   used to contact RabbitMQ nodes.

   GitHub issue: [rabbitmq-cli#237](https://github.com/rabbitmq/rabbitmq-cli/issues/237)


### Management Plugin

#### Bugs

 * Valid definitions could be rejected as invalid during import via HTTP API.

   GitHub issue: [rabbitmq-management#552](https://github.com/rabbitmq/rabbitmq-management/issues/552)

 * It wasn't possible to configure `path_prefix` via new style config file.

   GitHub issue: [rabbitmq-management#547](https://github.com/rabbitmq/rabbitmq-management/issues/547)


### Federation Plugin

#### Bugs

 * Valid upstreams were rejected as invalid when imported from a definition file.

   GitHub issue: [rabbitmq-federation#70](https://github.com/rabbitmq/rabbitmq-federation/issues/70)

 * Valid upstream sets were rejected as invalid when added using CLI tools.

   GitHub issue: [rabbitmq-federation#67](https://github.com/rabbitmq/rabbitmq-federation/issues/67)


### Peer Discovery AWS Plugin

#### Bugs

  * The plugin skipped registration and thus [randomized startup delay](https://www.rabbitmq.com/cluster-formation.html#initial-formation-race-condition) injection.

    GitHub issue: [rabbitmq-peer-discovery-aws#17](https://github.com/rabbitmq/rabbitmq-peer-discovery-aws/issues/17)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.4.tar.gz`.
