% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{markdown}
\alias{markdown}
\title{Insert inline Markdown}
\usage{
markdown(mds, extensions = TRUE, .noWS = NULL, ...)
}
\arguments{
\item{mds}{A character vector of Markdown source to convert to HTML. If the
vector has more than one element, a single-element character vector of
concatenated HTML is returned.}

\item{extensions}{Enable Github syntax extensions; defaults to \code{TRUE}.}

\item{.noWS}{Character vector used to omit some of the whitespace that would
normally be written around generated HTML. Valid options include \code{before},
\code{after}, and \code{outside} (equivalent to \code{before} and \code{end}).}

\item{...}{Additional arguments to pass to \code{\link[commonmark:commonmark]{commonmark::markdown_html()}}.
These arguments are \emph{\link[rlang:dyn-dots]{dynamic}}.}
}
\value{
a character vector marked as HTML.
}
\description{
This function accepts
\href{https://en.wikipedia.org/wiki/Markdown}{Markdown}-syntax text and returns
HTML that may be included in Shiny UIs.
}
\details{
Leading whitespace is trimmed from Markdown text with \code{\link[glue:trim]{glue::trim()}}.
Whitespace trimming ensures Markdown is processed correctly even when the
call to \code{markdown()} is indented within surrounding R code.

By default, \link[commonmark:extensions]{Github extensions} are enabled, but this
can be disabled by passing \code{extensions = FALSE}.

Markdown rendering is performed by \code{\link[commonmark:commonmark]{commonmark::markdown_html()}}. Additional
arguments to \code{markdown()} are passed as arguments to \code{markdown_html()}
}
\examples{
ui <- fluidPage(
  markdown("
    # Markdown Example

    This is a markdown paragraph, and will be contained within a `<p>` tag
    in the UI.

    The following is an unordered list, which will be represented in the UI as
    a `<ul>` with `<li>` children:

    * a bullet
    * another

    [Links](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) work;
    so does *emphasis*.

    To see more of what's possible, check out [commonmark.org/help](https://commonmark.org/help).
    ")
)
}
