% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleRepeated.R
\name{sampleRepeated}
\alias{sampleRepeated}
\title{Simulate Repeated Measurements over time}
\usage{
sampleRepeated(n, n.Xcont = 2, n.Xcat = 2, n.rep = 5, format = "long")
}
\arguments{
\item{n}{[integer] sample size.}

\item{n.Xcont}{[integer] number of continuous covariates acting on the latent variable.}

\item{n.Xcat}{[integer] number of categorical covariates acting on the latent variable.}

\item{n.rep}{[integer] number of measurement of the response variable.}

\item{format}{[character] should the dataset be returned in the \code{"long"} format or in the \code{"wide"} format.}
}
\value{
a \code{data.frame} object.
}
\description{
Simulate repeated measurements over time (one factor model).
}
\examples{

sampleRepeated(10, format = "wide")
sampleRepeated(10, format = "long")
}
