% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plotQualityProfile}
\alias{plotQualityProfile}
\title{Plot quality profile of a fastq file.}
\usage{
plotQualityProfile(fl, n = 5e+05, aggregate = FALSE)
}
\arguments{
\item{fl}{(Required). \code{character}.
File path(s) to fastq or fastq.gz file(s).}

\item{n}{(Optional). Default 500,000.
The number of records to sample from the fastq file.}

\item{aggregate}{(Optional). Default FALSE.
If TRUE, compute an aggregate quality profile for all fastq files provided.}
}
\value{
A \code{\link{ggplot}2} object.
 Will be rendered to default device if \code{\link{print}ed},
 or can be stored and further modified.
 See \code{\link{ggsave}} for additional options.
}
\description{
This function plots a visual summary of the distribution of quality scores
as a function of sequence position for the input fastq file(s).
}
\details{
The distribution of quality scores at each position is shown as a grey-scale
heat map, with dark colors corresponding to higher frequency. The plotted lines
show positional summary statistics: green is the mean, orange is the median, and
the dashed orange lines are the 25th and 75th quantiles.

If the sequences vary in length, a red line will be plotted showing the percentage
of reads that extend to at least that position.
}
\examples{
plotQualityProfile(system.file("extdata", "sam1F.fastq.gz", package="dada2"))

}
