% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/buildIndex.R
\name{buildIndex}
\alias{buildIndex}
\alias{buildIndex,missing-method}
\alias{buildIndex,KmknnParam-method}
\alias{buildIndex,VptreeParam-method}
\alias{buildIndex,AnnoyParam-method}
\alias{buildIndex,HnswParam-method}
\title{Build a nearest-neighbor index}
\usage{
buildIndex(X, ..., BNPARAM)
}
\arguments{
\item{X}{A numeric matrix where rows correspond to data points and columns correspond to variables (i.e., dimensions).}

\item{...}{Further arguments to be passed to individual methods.
This is guaranteed to include \code{transposed}.}

\item{BNPARAM}{A \linkS4class{BiocNeighborParam} object specifying the type of index to be constructed.
This defaults to a \linkS4class{KmknnParam} object if no argument is supplied.}
}
\value{
An instance of a \linkS4class{BiocNeighborIndex} subclass, containing indexing structures for the specified algorithm.
}
\description{
Build indices for nearest-neighbor searching with different algorithms.
}
\details{
Supplying a \linkS4class{KmknnParam} object as \code{BNPARAM} will dispatch to \code{\link{buildKmknn}}.

Supplying a \linkS4class{VptreeParam} object as \code{BNPARAM} will dispatch to \code{\link{buildVptree}}.

Supplying an \linkS4class{AnnoyParam} object as \code{BNPARAM} will dispatch to \code{\link{buildAnnoy}}.

Supplying an \linkS4class{HnswParam} object as \code{BNPARAM} will dispatch to \code{\link{buildHnsw}}.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
(k.out <- buildIndex(Y))
(a.out <- buildIndex(Y, BNPARAM=AnnoyParam()))

}
\seealso{
\code{\link{buildKmknn}},
\code{\link{buildVptree}},
\code{\link{buildAnnoy}} 
and \code{\link{buildHnsw}} for specific methods.
}
\author{
Aaron Lun
}
