# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core import PipelineClient
from azure.core.rest import HttpRequest, HttpResponse

from ._configuration import EasmClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AssetsOperations,
    DiscoveryGroupsOperations,
    DiscoveryTemplatesOperations,
    ReportsOperations,
    SavedFiltersOperations,
    TasksOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class EasmClient:  # pylint: disable=client-accepts-api-version-keyword
    """Defender EASM discovers and maps your digital attack surface to provide an "outside-in"
    perspective using probes to discover assets. The assets are provided with detailed metadata
    associated, including vulnerabilities, configurations and web components, allowing customers to
    view and prioritize external risk. The EASM REST API enables you to develop clients that
    integrate with your application.

    :ivar assets: AssetsOperations operations
    :vartype assets: azure.defender.easm.operations.AssetsOperations
    :ivar discovery_groups: DiscoveryGroupsOperations operations
    :vartype discovery_groups: azure.defender.easm.operations.DiscoveryGroupsOperations
    :ivar discovery_templates: DiscoveryTemplatesOperations operations
    :vartype discovery_templates: azure.defender.easm.operations.DiscoveryTemplatesOperations
    :ivar reports: ReportsOperations operations
    :vartype reports: azure.defender.easm.operations.ReportsOperations
    :ivar saved_filters: SavedFiltersOperations operations
    :vartype saved_filters: azure.defender.easm.operations.SavedFiltersOperations
    :ivar tasks: TasksOperations operations
    :vartype tasks: azure.defender.easm.operations.TasksOperations
    :param endpoint: The endpoint hosting the requested resource. For example,
     {region}.easm.defender.microsoft.com. Required.
    :type endpoint: str
    :param resource_group_name: The name of the Resource Group. Required.
    :type resource_group_name: str
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param workspace_name: The name of the Workspace. Required.
    :type workspace_name: str
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :keyword api_version: Api Version. Default value is "2022-11-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self,
        endpoint: str,
        resource_group_name: str,
        subscription_id: str,
        workspace_name: str,
        credential: "TokenCredential",
        **kwargs: Any
    ) -> None:
        _endpoint = "https://{endpoint}"
        self._config = EasmClientConfiguration(
            endpoint=endpoint,
            resource_group_name=resource_group_name,
            subscription_id=subscription_id,
            workspace_name=workspace_name,
            credential=credential,
            **kwargs
        )
        self._client: PipelineClient = PipelineClient(base_url=_endpoint, config=self._config, **kwargs)

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.assets = AssetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.discovery_groups = DiscoveryGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.discovery_templates = DiscoveryTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.reports = ReportsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.saved_filters = SavedFiltersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tasks = TasksOperations(self._client, self._config, self._serialize, self._deserialize)

    def send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client.send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "EasmClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details) -> None:
        self._client.__exit__(*exc_details)
