# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional

import msrest.serialization


class CommunicationIdentity(msrest.serialization.Model):
    """A communication identity.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Identifier of the identity.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(CommunicationIdentity, self).__init__(**kwargs)
        self.id = id


class CommunicationIdentityToken(msrest.serialization.Model):
    """CommunicationIdentityToken.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Identifier of the identity owning the token.
    :type id: str
    :param token: Required. The token issued for the identity.
    :type token: str
    :param expires_on: Required. The expiry time of the token.
    :type expires_on: ~datetime.datetime
    """

    _validation = {
        'id': {'required': True},
        'token': {'required': True},
        'expires_on': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'expires_on': {'key': 'expiresOn', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        id: str,
        token: str,
        expires_on: datetime.datetime,
        **kwargs
    ):
        super(CommunicationIdentityToken, self).__init__(**kwargs)
        self.id = id
        self.token = token
        self.expires_on = expires_on


class CommunicationIdentityUpdateRequest(msrest.serialization.Model):
    """CommunicationIdentityUpdateRequest.

    :param tokens_valid_from: All tokens that are issued prior to this time will be revoked.
    :type tokens_valid_from: ~datetime.datetime
    """

    _attribute_map = {
        'tokens_valid_from': {'key': 'tokensValidFrom', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        tokens_valid_from: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(CommunicationIdentityUpdateRequest, self).__init__(**kwargs)
        self.tokens_valid_from = tokens_valid_from


class CommunicationTokenRequest(msrest.serialization.Model):
    """CommunicationTokenRequest.

    All required parameters must be populated in order to send to Azure.

    :param scopes: Required. List of scopes attached to the token.
    :type scopes: list[str]
    """

    _validation = {
        'scopes': {'required': True},
    }

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        scopes: List[str],
        **kwargs
    ):
        super(CommunicationTokenRequest, self).__init__(**kwargs)
        self.scopes = scopes
