; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=mips-linux-gnu -march=mips -mcpu=mips32 | FileCheck %s --check-prefixes=CHECK,CHECK-BE
; RUN: llc < %s -mtriple=mipsel-linux-gnu -march=mipsel -mcpu=mips32 | FileCheck %s --check-prefixes=CHECK,CHECK-LE

declare i8 @llvm.fshl.i8(i8, i8, i8)
declare i16 @llvm.fshl.i16(i16, i16, i16)
declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i64 @llvm.fshl.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)

declare i8 @llvm.fshr.i8(i8, i8, i8)
declare i16 @llvm.fshr.i16(i16, i16, i16)
declare i32 @llvm.fshr.i32(i32, i32, i32)
declare i64 @llvm.fshr.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshr.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)

; When first 2 operands match, it's a rotate.

define i8 @rotl_i8_const_shift(i8 %x) {
; CHECK-LABEL: rotl_i8_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll $1, $4, 3
; CHECK-NEXT:    andi $2, $4, 224
; CHECK-NEXT:    srl $2, $2, 5
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 3)
  ret i8 %f
}

define i64 @rotl_i64_const_shift(i64 %x) {
; CHECK-LABEL: rotl_i64_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl $1, $5, 29
; CHECK-NEXT:    sll $2, $4, 3
; CHECK-NEXT:    or $2, $2, $1
; CHECK-NEXT:    srl $1, $4, 29
; CHECK-NEXT:    sll $3, $5, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $3, $3, $1
  %f = call i64 @llvm.fshl.i64(i64 %x, i64 %x, i64 3)
  ret i64 %f
}

; When first 2 operands match, it's a rotate (by variable amount).

define i16 @rotl_i16(i16 %x, i16 %z) {
; CHECK-LABEL: rotl_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $5, 15
; CHECK-NEXT:    sllv $1, $4, $1
; CHECK-NEXT:    negu $2, $5
; CHECK-NEXT:    andi $2, $2, 15
; CHECK-NEXT:    andi $3, $4, 65535
; CHECK-NEXT:    srlv $2, $3, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i16 @llvm.fshl.i16(i16 %x, i16 %x, i16 %z)
  ret i16 %f
}

define i32 @rotl_i32(i32 %x, i32 %z) {
; CHECK-LABEL: rotl_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $5, 31
; CHECK-NEXT:    sllv $1, $4, $1
; CHECK-NEXT:    negu $2, $5
; CHECK-NEXT:    andi $2, $2, 31
; CHECK-NEXT:    srlv $2, $4, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %x, i32 %z)
  ret i32 %f
}

define i64 @rotl_i64(i64 %x, i64 %z) {
; CHECK-BE-LABEL: rotl_i64:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    negu $1, $7
; CHECK-BE-NEXT:    andi $3, $1, 63
; CHECK-BE-NEXT:    srlv $6, $4, $3
; CHECK-BE-NEXT:    andi $1, $1, 32
; CHECK-BE-NEXT:    andi $2, $7, 63
; CHECK-BE-NEXT:    move $8, $6
; CHECK-BE-NEXT:    movn $8, $zero, $1
; CHECK-BE-NEXT:    sllv $9, $4, $2
; CHECK-BE-NEXT:    srl $10, $5, 1
; CHECK-BE-NEXT:    not $11, $2
; CHECK-BE-NEXT:    srlv $10, $10, $11
; CHECK-BE-NEXT:    or $9, $9, $10
; CHECK-BE-NEXT:    sllv $10, $5, $2
; CHECK-BE-NEXT:    andi $7, $7, 32
; CHECK-BE-NEXT:    movn $9, $10, $7
; CHECK-BE-NEXT:    or $2, $9, $8
; CHECK-BE-NEXT:    srlv $5, $5, $3
; CHECK-BE-NEXT:    not $3, $3
; CHECK-BE-NEXT:    sll $4, $4, 1
; CHECK-BE-NEXT:    sllv $3, $4, $3
; CHECK-BE-NEXT:    or $3, $3, $5
; CHECK-BE-NEXT:    movn $3, $6, $1
; CHECK-BE-NEXT:    movn $10, $zero, $7
; CHECK-BE-NEXT:    jr $ra
; CHECK-BE-NEXT:    or $3, $10, $3
;
; CHECK-LE-LABEL: rotl_i64:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    negu $1, $6
; CHECK-LE-NEXT:    andi $2, $1, 63
; CHECK-LE-NEXT:    srlv $7, $5, $2
; CHECK-LE-NEXT:    andi $1, $1, 32
; CHECK-LE-NEXT:    andi $3, $6, 63
; CHECK-LE-NEXT:    move $8, $7
; CHECK-LE-NEXT:    movn $8, $zero, $1
; CHECK-LE-NEXT:    sllv $9, $5, $3
; CHECK-LE-NEXT:    srl $10, $4, 1
; CHECK-LE-NEXT:    not $11, $3
; CHECK-LE-NEXT:    srlv $10, $10, $11
; CHECK-LE-NEXT:    or $9, $9, $10
; CHECK-LE-NEXT:    sllv $10, $4, $3
; CHECK-LE-NEXT:    andi $6, $6, 32
; CHECK-LE-NEXT:    movn $9, $10, $6
; CHECK-LE-NEXT:    or $3, $9, $8
; CHECK-LE-NEXT:    srlv $4, $4, $2
; CHECK-LE-NEXT:    not $2, $2
; CHECK-LE-NEXT:    sll $5, $5, 1
; CHECK-LE-NEXT:    sllv $2, $5, $2
; CHECK-LE-NEXT:    or $2, $2, $4
; CHECK-LE-NEXT:    movn $2, $7, $1
; CHECK-LE-NEXT:    movn $10, $zero, $6
; CHECK-LE-NEXT:    jr $ra
; CHECK-LE-NEXT:    or $2, $10, $2
  %f = call i64 @llvm.fshl.i64(i64 %x, i64 %x, i64 %z)
  ret i64 %f
}

; Vector rotate.

define <4 x i32> @rotl_v4i32(<4 x i32> %x, <4 x i32> %z) {
; CHECK-LABEL: rotl_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw $1, 24($sp)
; CHECK-NEXT:    negu $2, $1
; CHECK-NEXT:    lw $3, 20($sp)
; CHECK-NEXT:    negu $8, $3
; CHECK-NEXT:    andi $8, $8, 31
; CHECK-NEXT:    andi $2, $2, 31
; CHECK-NEXT:    andi $3, $3, 31
; CHECK-NEXT:    andi $1, $1, 31
; CHECK-NEXT:    lw $9, 16($sp)
; CHECK-NEXT:    sllv $1, $6, $1
; CHECK-NEXT:    srlv $6, $6, $2
; CHECK-NEXT:    sllv $3, $5, $3
; CHECK-NEXT:    srlv $5, $5, $8
; CHECK-NEXT:    andi $2, $9, 31
; CHECK-NEXT:    sllv $2, $4, $2
; CHECK-NEXT:    negu $8, $9
; CHECK-NEXT:    andi $8, $8, 31
; CHECK-NEXT:    srlv $4, $4, $8
; CHECK-NEXT:    lw $8, 28($sp)
; CHECK-NEXT:    or $2, $2, $4
; CHECK-NEXT:    or $3, $3, $5
; CHECK-NEXT:    or $4, $1, $6
; CHECK-NEXT:    andi $1, $8, 31
; CHECK-NEXT:    sllv $1, $7, $1
; CHECK-NEXT:    negu $5, $8
; CHECK-NEXT:    andi $5, $5, 31
; CHECK-NEXT:    srlv $5, $7, $5
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $5, $1, $5
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> %z)
  ret <4 x i32> %f
}

; Vector rotate by constant splat amount.

define <4 x i32> @rotl_v4i32_rotl_const_shift(<4 x i32> %x) {
; CHECK-LABEL: rotl_v4i32_rotl_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl $1, $5, 29
; CHECK-NEXT:    sll $3, $5, 3
; CHECK-NEXT:    srl $2, $4, 29
; CHECK-NEXT:    sll $4, $4, 3
; CHECK-NEXT:    or $2, $4, $2
; CHECK-NEXT:    or $3, $3, $1
; CHECK-NEXT:    srl $1, $6, 29
; CHECK-NEXT:    sll $4, $6, 3
; CHECK-NEXT:    or $4, $4, $1
; CHECK-NEXT:    srl $1, $7, 29
; CHECK-NEXT:    sll $5, $7, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $5, $5, $1
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 3, i32 3, i32 3, i32 3>)
  ret <4 x i32> %f
}

; Repeat everything for funnel shift right.

; When first 2 operands match, it's a rotate.

define i8 @rotr_i8_const_shift(i8 %x) {
; CHECK-LABEL: rotr_i8_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll $1, $4, 5
; CHECK-NEXT:    andi $2, $4, 248
; CHECK-NEXT:    srl $2, $2, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 3)
  ret i8 %f
}

define i32 @rotr_i32_const_shift(i32 %x) {
; CHECK-LABEL: rotr_i32_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll $1, $4, 29
; CHECK-NEXT:    srl $2, $4, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %x, i32 3)
  ret i32 %f
}

; When first 2 operands match, it's a rotate (by variable amount).

define i16 @rotr_i16(i16 %x, i16 %z) {
; CHECK-LABEL: rotr_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $5, 15
; CHECK-NEXT:    andi $2, $4, 65535
; CHECK-NEXT:    srlv $1, $2, $1
; CHECK-NEXT:    negu $2, $5
; CHECK-NEXT:    andi $2, $2, 15
; CHECK-NEXT:    sllv $2, $4, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i16 @llvm.fshr.i16(i16 %x, i16 %x, i16 %z)
  ret i16 %f
}

define i32 @rotr_i32(i32 %x, i32 %z) {
; CHECK-LABEL: rotr_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $5, 31
; CHECK-NEXT:    srlv $1, $4, $1
; CHECK-NEXT:    negu $2, $5
; CHECK-NEXT:    andi $2, $2, 31
; CHECK-NEXT:    sllv $2, $4, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %x, i32 %z)
  ret i32 %f
}

define i64 @rotr_i64(i64 %x, i64 %z) {
; CHECK-BE-LABEL: rotr_i64:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    negu $1, $7
; CHECK-BE-NEXT:    andi $2, $1, 63
; CHECK-BE-NEXT:    sllv $6, $5, $2
; CHECK-BE-NEXT:    andi $1, $1, 32
; CHECK-BE-NEXT:    andi $3, $7, 63
; CHECK-BE-NEXT:    move $8, $6
; CHECK-BE-NEXT:    movn $8, $zero, $1
; CHECK-BE-NEXT:    srlv $9, $5, $3
; CHECK-BE-NEXT:    sll $10, $4, 1
; CHECK-BE-NEXT:    not $11, $3
; CHECK-BE-NEXT:    sllv $10, $10, $11
; CHECK-BE-NEXT:    or $9, $10, $9
; CHECK-BE-NEXT:    srlv $10, $4, $3
; CHECK-BE-NEXT:    andi $7, $7, 32
; CHECK-BE-NEXT:    movn $9, $10, $7
; CHECK-BE-NEXT:    or $3, $9, $8
; CHECK-BE-NEXT:    sllv $4, $4, $2
; CHECK-BE-NEXT:    not $2, $2
; CHECK-BE-NEXT:    srl $5, $5, 1
; CHECK-BE-NEXT:    srlv $2, $5, $2
; CHECK-BE-NEXT:    or $2, $4, $2
; CHECK-BE-NEXT:    movn $2, $6, $1
; CHECK-BE-NEXT:    movn $10, $zero, $7
; CHECK-BE-NEXT:    jr $ra
; CHECK-BE-NEXT:    or $2, $10, $2
;
; CHECK-LE-LABEL: rotr_i64:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    negu $1, $6
; CHECK-LE-NEXT:    andi $3, $1, 63
; CHECK-LE-NEXT:    sllv $7, $4, $3
; CHECK-LE-NEXT:    andi $1, $1, 32
; CHECK-LE-NEXT:    andi $2, $6, 63
; CHECK-LE-NEXT:    move $8, $7
; CHECK-LE-NEXT:    movn $8, $zero, $1
; CHECK-LE-NEXT:    srlv $9, $4, $2
; CHECK-LE-NEXT:    sll $10, $5, 1
; CHECK-LE-NEXT:    not $11, $2
; CHECK-LE-NEXT:    sllv $10, $10, $11
; CHECK-LE-NEXT:    or $9, $10, $9
; CHECK-LE-NEXT:    srlv $10, $5, $2
; CHECK-LE-NEXT:    andi $6, $6, 32
; CHECK-LE-NEXT:    movn $9, $10, $6
; CHECK-LE-NEXT:    or $2, $9, $8
; CHECK-LE-NEXT:    sllv $5, $5, $3
; CHECK-LE-NEXT:    not $3, $3
; CHECK-LE-NEXT:    srl $4, $4, 1
; CHECK-LE-NEXT:    srlv $3, $4, $3
; CHECK-LE-NEXT:    or $3, $5, $3
; CHECK-LE-NEXT:    movn $3, $7, $1
; CHECK-LE-NEXT:    movn $10, $zero, $6
; CHECK-LE-NEXT:    jr $ra
; CHECK-LE-NEXT:    or $3, $10, $3
  %f = call i64 @llvm.fshr.i64(i64 %x, i64 %x, i64 %z)
  ret i64 %f
}

; Vector rotate.

define <4 x i32> @rotr_v4i32(<4 x i32> %x, <4 x i32> %z) {
; CHECK-LABEL: rotr_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw $1, 24($sp)
; CHECK-NEXT:    negu $2, $1
; CHECK-NEXT:    lw $3, 20($sp)
; CHECK-NEXT:    negu $8, $3
; CHECK-NEXT:    andi $8, $8, 31
; CHECK-NEXT:    andi $2, $2, 31
; CHECK-NEXT:    andi $3, $3, 31
; CHECK-NEXT:    andi $1, $1, 31
; CHECK-NEXT:    lw $9, 16($sp)
; CHECK-NEXT:    srlv $1, $6, $1
; CHECK-NEXT:    sllv $6, $6, $2
; CHECK-NEXT:    srlv $3, $5, $3
; CHECK-NEXT:    sllv $5, $5, $8
; CHECK-NEXT:    andi $2, $9, 31
; CHECK-NEXT:    srlv $2, $4, $2
; CHECK-NEXT:    negu $8, $9
; CHECK-NEXT:    andi $8, $8, 31
; CHECK-NEXT:    sllv $4, $4, $8
; CHECK-NEXT:    lw $8, 28($sp)
; CHECK-NEXT:    or $2, $2, $4
; CHECK-NEXT:    or $3, $3, $5
; CHECK-NEXT:    or $4, $1, $6
; CHECK-NEXT:    andi $1, $8, 31
; CHECK-NEXT:    srlv $1, $7, $1
; CHECK-NEXT:    negu $5, $8
; CHECK-NEXT:    andi $5, $5, 31
; CHECK-NEXT:    sllv $5, $7, $5
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $5, $1, $5
  %f = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> %z)
  ret <4 x i32> %f
}

; Vector rotate by constant splat amount.

define <4 x i32> @rotr_v4i32_const_shift(<4 x i32> %x) {
; CHECK-LABEL: rotr_v4i32_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll $1, $5, 29
; CHECK-NEXT:    srl $3, $5, 3
; CHECK-NEXT:    sll $2, $4, 29
; CHECK-NEXT:    srl $4, $4, 3
; CHECK-NEXT:    or $2, $4, $2
; CHECK-NEXT:    or $3, $3, $1
; CHECK-NEXT:    sll $1, $6, 29
; CHECK-NEXT:    srl $4, $6, 3
; CHECK-NEXT:    or $4, $4, $1
; CHECK-NEXT:    sll $1, $7, 29
; CHECK-NEXT:    srl $5, $7, 3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $5, $5, $1
  %f = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 3, i32 3, i32 3, i32 3>)
  ret <4 x i32> %f
}

define i32 @rotl_i32_shift_by_bitwidth(i32 %x) {
; CHECK-LABEL: rotl_i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $4
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %x, i32 32)
  ret i32 %f
}

define i32 @rotr_i32_shift_by_bitwidth(i32 %x) {
; CHECK-LABEL: rotr_i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $4
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %x, i32 32)
  ret i32 %f
}

define <4 x i32> @rotl_v4i32_shift_by_bitwidth(<4 x i32> %x) {
; CHECK-LABEL: rotl_v4i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    move $2, $4
; CHECK-NEXT:    move $3, $5
; CHECK-NEXT:    move $4, $6
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $5, $7
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 32, i32 32, i32 32, i32 32>)
  ret <4 x i32> %f
}

define <4 x i32> @rotr_v4i32_shift_by_bitwidth(<4 x i32> %x) {
; CHECK-LABEL: rotr_v4i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    move $2, $4
; CHECK-NEXT:    move $3, $5
; CHECK-NEXT:    move $4, $6
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $5, $7
  %f = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 32, i32 32, i32 32, i32 32>)
  ret <4 x i32> %f
}

