#!/bin/sh
#
# Copyright (c) 2012  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

[ -z "$CONFGET" ] && CONFGET='./confget'
[ -z "$TESTDIR" ] && TESTDIR='t'

T1="$TESTDIR/t1.ini"
T2="$TESTDIR/t2.ini"

echo '1..3'

if [ ! -f "$T1" ]; then
	echo "Bail out!  No test file $T1"
	exit 255
fi
if [ ! -f "$T2" ]; then
	echo "Bail out!  No test file $T2"
	exit 255
fi

# OK, this is so ugly it hurts...
$CONFGET -f "$T1" -q sections 2>&1 | (
	read v
	if [ "$v" != 'a' ]; then
		echo "nok 1 expected a got $v"
	else
		read v
		if [ "$v" != 'b sect' ]; then
			echo "nok 1 expected b sect got $v"
		else
			read v
			if [ "$v" != 'c' ]; then
				echo "nok 1 expected c got $v"
			else
				read v
				if [ -n "$v" ]; then
					echo "nok 1 expected empty got $v"
				else
					echo 'ok 1'
				fi
			fi
		fi
	fi
)
#if [ "$v" = "a\nb sect\nc" ]; then echo 'ok 1'; else echo "not ok 1 v is $v"; fi

v=`$CONFGET -f "$T2" -q sections 2>&1`
if [ "$v" = 'sec1' ]; then echo 'ok 2'; else echo "not ok 2 v is $v"; fi

v=`$CONFGET -q sections -t http 2>&1`
if expr "x$v" : 'x.* is only supported ' > /dev/null; then echo 'ok 3'; else echo "not ok 3 v is $v"; fi
