{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FColorPersistent: TCastleColorPersistent;
  function GetColorForPersistent: TCastleColor;
  procedure SetColorForPersistent(const AValue: TCastleColor);
published
  { @link(Color) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Color) directly.

    @seealso Color }
  property ColorPersistent: TCastleColorPersistent read FColorPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleLabel.GetColorForPersistent: TCastleColor;
begin
  Result := Color;
end;

procedure TCastleLabel.SetColorForPersistent(const AValue: TCastleColor);
begin
  Color := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FColorPersistent := TCastleColorPersistent.Create;
  FColorPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetColorForPersistent;
  FColorPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetColorForPersistent;
  FColorPersistent.InternalDefaultValue := Color; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FColorPersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FFrameColorPersistent: TCastleColorPersistent;
  function GetFrameColorForPersistent: TCastleColor;
  procedure SetFrameColorForPersistent(const AValue: TCastleColor);
published
  { @link(FrameColor) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(FrameColor) directly.

    @seealso FrameColor }
  property FrameColorPersistent: TCastleColorPersistent read FFrameColorPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleLabel.GetFrameColorForPersistent: TCastleColor;
begin
  Result := FrameColor;
end;

procedure TCastleLabel.SetFrameColorForPersistent(const AValue: TCastleColor);
begin
  FrameColor := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FFrameColorPersistent := TCastleColorPersistent.Create;
  FFrameColorPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetFrameColorForPersistent;
  FFrameColorPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetFrameColorForPersistent;
  FFrameColorPersistent.InternalDefaultValue := FrameColor; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FFrameColorPersistent);
{$endif read_implementation_destructor}

