{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdRadius: TSFFloat;
    { Internal wrapper for property @link(Radius). This wrapper API may change, we advise to access simpler @link(Radius) instead. }
    public property FdRadius: TSFFloat read FFdRadius;
    {  }
    property Radius: Single read GetRadius write SetRadius;

{$endif read_interface}

{$ifdef read_implementation}

{ TSphereNode_1 ----------------------------------------------- }

function TSphereNode_1.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TSphereNode_1.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

class function TSphereNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TSphereNode_1.ClassX3DType: String;
begin
  Result := 'Sphere';
end;

procedure TSphereNode_1.CreateNode;
begin
  inherited;

  FFdRadius := TSFFloat.Create(Self, True, 'radius', 1);
   FdRadius.ChangeAlways := chGeometry;
   FdRadius.MustBeNonnegative := true;
  AddField(FFdRadius);
end;

{$endif read_implementation}
