{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetControlPoint: TAbstractCoordinateNode;
    procedure SetControlPoint(const Value: TAbstractCoordinateNode);
    function GetOrder: Integer;
    procedure SetOrder(const Value: Integer);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventSet_fraction: TSFFloatEvent;
    {  }
    public property EventSet_fraction: TSFFloatEvent read FEventSet_fraction;

    strict private FFdControlPoint: TSFNode;
    { Internal wrapper for property @link(ControlPoint). This wrapper API may change, we advise to access simpler @link(ControlPoint) instead. }
    public property FdControlPoint: TSFNode read FFdControlPoint;
    {  }
    property ControlPoint: TAbstractCoordinateNode read GetControlPoint write SetControlPoint;

    strict private FFdKnot: TMFDouble;
    { Internal wrapper for property @link(Knot). This wrapper API may change, we advise to access simpler @link(Knot) instead. }
    public property FdKnot: TMFDouble read FFdKnot;
    {  }
    procedure SetKnot(const Value: array of Double); overload;
    {  }
    procedure SetKnot(const Value: TDoubleList); overload;

    strict private FFdOrder: TSFInt32;
    { Internal wrapper for property @link(Order). This wrapper API may change, we advise to access simpler @link(Order) instead. }
    public property FdOrder: TSFInt32 read FFdOrder;
    {  }
    property Order: Integer read GetOrder write SetOrder;

    strict private FFdWeight: TMFDouble;
    { Internal wrapper for property @link(Weight). This wrapper API may change, we advise to access simpler @link(Weight) instead. }
    public property FdWeight: TMFDouble read FFdWeight;
    {  }
    procedure SetWeight(const Value: array of Double); overload;
    {  }
    procedure SetWeight(const Value: TDoubleList); overload;

    strict private FEventValue_changed: TSFRotationEvent;
    {  }
    public property EventValue_changed: TSFRotationEvent read FEventValue_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsOrientationInterpolatorNode ----------------------------------------------- }

function TNurbsOrientationInterpolatorNode.GetControlPoint: TAbstractCoordinateNode;
begin
  if FdControlPoint.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdControlPoint.Value)
  else
    Result := nil;
end;

procedure TNurbsOrientationInterpolatorNode.SetControlPoint(const Value: TAbstractCoordinateNode);
begin
  FdControlPoint.Send(Value);
end;

procedure TNurbsOrientationInterpolatorNode.SetKnot(const Value: array of Double);
begin
  FdKnot.Send(Value);
end;

procedure TNurbsOrientationInterpolatorNode.SetKnot(const Value: TDoubleList);
begin
  FdKnot.Send(Value);
end;

function TNurbsOrientationInterpolatorNode.GetOrder: Integer;
begin
  Result := FdOrder.Value;
end;

procedure TNurbsOrientationInterpolatorNode.SetOrder(const Value: Integer);
begin
  FdOrder.Send(Value);
end;

procedure TNurbsOrientationInterpolatorNode.SetWeight(const Value: array of Double);
begin
  FdWeight.Send(Value);
end;

procedure TNurbsOrientationInterpolatorNode.SetWeight(const Value: TDoubleList);
begin
  FdWeight.Send(Value);
end;

class function TNurbsOrientationInterpolatorNode.ClassX3DType: String;
begin
  Result := 'NurbsOrientationInterpolator';
end;

procedure TNurbsOrientationInterpolatorNode.CreateNode;
begin
  inherited;

  FEventSet_fraction := TSFFloatEvent.Create(Self, 'set_fraction', true);
  AddEvent(FEventSet_fraction);

  FFdControlPoint := TSFNode.Create(Self, True, 'controlPoint', [TAbstractCoordinateNode]);
   FdControlPoint.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdControlPoint);

  FFdKnot := TMFDouble.Create(Self, True, 'knot', []);
   FdKnot.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdKnot);

  FFdOrder := TSFInt32.Create(Self, True, 'order', 3);
   FdOrder.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOrder);

  FFdWeight := TMFDouble.Create(Self, True, 'weight', []);
   FdWeight.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWeight);

  FEventValue_changed := TSFRotationEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);
end;

{$endif read_implementation}
